/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.command;

import com.ibm.hsc.client.PICECDataBean;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCLPARClient;
import com.ibm.hsc.client.PILPARDataBean;
import com.ibm.hsc.client.PILPARProfileDataBean;
import com.ibm.hsc.client.PISysProfDataBean;
import com.ibm.hsc.command.PIHMCCommandUtils;
import com.ibm.hsc.command.PIProfCommandUtils;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hsc.common.util.CSVRecord;
import com.ibm.hsc.common.util.PIHscUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt8;

public class PISystemConfigurationCreate {
    private static final String PROFILE_NAME_ATTR = "profile_name";
    private static final String PARTITION_NAME_ATTR = "lpar_name";
    private static final int NUM_VALID_PARMS = 5;
    private String m_resourceType;
    private String m_managedSystem;
    private String m_filename;
    private String m_inputData;
    private HashMap m_validParms = new HashMap(11, 0.5f);
    private String m_delimiter = ",";
    private Vector m_input;
    private String m_intSysName = null;
    private String m_sysProfName = null;
    private String m_partName = null;
    private String m_partProfName = null;
    private PIHSCClientObjectFactory m_factory = null;
    private PIHSCCECClient m_CECClient = null;
    private PrintStream m_out;
    private boolean m_writeStatus;

    private PISystemConfigurationCreate(PIHSCCECClient pIHSCCECClient, PrintStream printStream, boolean bl) {
        this.m_CECClient = pIHSCCECClient;
        this.m_out = printStream;
        this.m_writeStatus = bl;
        this.m_intSysName = this.m_CECClient.getIntName();
        this.m_validParms.put("-m", null);
        this.m_validParms.put("-r", null);
        this.m_validParms.put("-f", null);
        this.m_validParms.put("-i", null);
        this.m_validParms.put("-p", null);
    }

    private void advValidateLpar(PILPARDataBean pILPARDataBean) throws PIHscClientException {
        String string = pILPARDataBean.getInternalName();
        String string2 = pILPARDataBean.getUserDefinedName();
        UnsignedInt8 unsignedInt8 = pILPARDataBean.getDefinitionState();
        UnsignedInt16 unsignedInt16 = pILPARDataBean.getClusterID();
        UnsignedInt8 unsignedInt82 = pILPARDataBean.getSharedPoolUtilizationAuthority();
        String string3 = "";
        if (string == null) {
            pILPARDataBean.m_internalName = "65535*" + this.m_intSysName;
        }
        if (unsignedInt82 == null) {
            pILPARDataBean.m_sharedPoolUtilizationAuthority = new UnsignedInt8(0);
        }
        if (string2 == null) {
            string3 = "name";
        }
        if (unsignedInt8 == null) {
            string3 = string3 + ", lpar_env";
        }
        if (string3.length() > 0) {
            if (string3.startsWith(", ")) {
                string3 = string3.substring(2, string3.length());
            }
            String[] stringArray = new String[]{string3};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", stringArray, null);
        }
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"hyp_capabilities"});
        if (unsignedInt8.equals((Object)PILPARDataBean.RPA_IO_SERVER_NOT_BOOTABLE) && !pICECDataBean.isIOServerCapable()) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "NOT_IO_SERVER_CAPABLE_ERROR", null, null);
        }
        if (unsignedInt8.equals((Object)PILPARDataBean.OS400_NOT_BOOTABLE) && !pICECDataBean.isOS400Capable()) {
            throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "022A", null, null);
        }
        try {
            if (!PIHscUtil.isCorrectNameLength(string2, 47)) {
                String[] stringArray = new String[]{string2};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PARTITION_NAME_LENGTH", stringArray, null);
            }
            if (!PIHscUtil.nameHasCorrectCharacters(string2)) {
                String[] stringArray = new String[]{"name=" + string2};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{"name=" + string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
        }
        if (unsignedInt16 != null) {
            if (unsignedInt16.intValue() > Short.MAX_VALUE) {
                String[] stringArray = new String[]{"work_group_id=" + unsignedInt16};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
            }
        } else {
            pILPARDataBean.setClusterID(new UnsignedInt16(65535));
        }
    }

    private void doPartitionCreate() throws PIHscClientException {
        for (int i = 0; i < this.m_input.size(); ++i) {
            String string;
            PILPARDataBean pILPARDataBean = new PILPARDataBean();
            PILPARProfileDataBean pILPARProfileDataBean = new PILPARProfileDataBean();
            Boolean[] booleanArray = new Boolean[6];
            pILPARProfileDataBean.setTaggedIOInfo(booleanArray);
            boolean bl = false;
            boolean bl2 = false;
            CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(i), true, this.m_delimiter);
            Iterator iterator = cSVRecord.iterator();
            while (iterator.hasNext()) {
                String[] stringArray;
                string = (String)iterator.next();
                int n = string.indexOf("=");
                if (n == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string2.length() == 0 || string3.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                if ("lpar_id".equals(string2)) {
                    try {
                        stringArray = new UnsignedInt8(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        String[] stringArray2 = new String[]{string};
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray2, null);
                    }
                    pILPARDataBean.m_internalName = string3 + "*" + this.m_intSysName;
                    continue;
                }
                if ("name".equals(string2)) {
                    pILPARDataBean.setUserDefinedName(string3);
                    this.m_partName = string3;
                    continue;
                }
                if ("lpar_type".equals(string2) || "lpar_env".equals(string2)) {
                    if ("lpar_type".equals(string2)) {
                        bl = true;
                        if (bl2) {
                            stringArray = new String[]{"lpar_env, lpar_type"};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", stringArray, null);
                        }
                    } else {
                        bl2 = true;
                        if (bl) {
                            stringArray = new String[]{"lpar_env, lpar_type"};
                            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", stringArray, null);
                        }
                    }
                    if ("os400".equals(string3.toLowerCase())) {
                        pILPARDataBean.setDefinitionState(PILPARDataBean.OS400_NOT_BOOTABLE);
                        pILPARProfileDataBean.setOsType(new UnsignedInt8(129));
                        continue;
                    }
                    if ("aixlinux".equals(string3.toLowerCase())) {
                        pILPARDataBean.setDefinitionState(PILPARDataBean.RPA_NOT_BOOTABLE);
                        pILPARProfileDataBean.setOsType(new UnsignedInt8(1));
                        continue;
                    }
                    if ("ess".equals(string3.toLowerCase())) {
                        pILPARDataBean.setDefinitionState(PILPARDataBean.MEGAMOUTH_NOT_BOOTABLE);
                        pILPARProfileDataBean.setOsType(new UnsignedInt8(4));
                        continue;
                    }
                    if ("vioserver".equals(string3.toLowerCase())) {
                        pILPARDataBean.setDefinitionState(PILPARDataBean.RPA_IO_SERVER_NOT_BOOTABLE);
                        pILPARProfileDataBean.setOsType(new UnsignedInt8(65));
                        continue;
                    }
                    stringArray = new String[]{string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
                }
                if ("work_group_id".equals(string2)) {
                    if ("none".equals(string3.toLowerCase())) continue;
                    try {
                        pILPARDataBean.setClusterID(new UnsignedInt16(string3));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String[] stringArray3 = new String[]{string};
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray3, null);
                    }
                }
                if ("shared_proc_pool_util_auth".equals(string2)) {
                    if (PIHMCCommandUtils.decodeBoolean(string3) != null) {
                        pILPARDataBean.setSharedPoolUtilizationAuthority(new UnsignedInt8(string3));
                        continue;
                    }
                    stringArray = new String[]{string};
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray, null);
                }
                if (PROFILE_NAME_ATTR.equals(string2)) {
                    pILPARProfileDataBean.setName(string3);
                    continue;
                }
                PIProfCommandUtils.setProfBean(pILPARProfileDataBean, string2, string3, this.m_intSysName, 0);
            }
            this.advValidateLpar(pILPARDataBean);
            string = pILPARProfileDataBean.getName();
            if (string == null) {
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", new String[]{PROFILE_NAME_ATTR}, null);
            }
            PIProfCommandUtils.advValidateProfile(pILPARProfileDataBean, this.m_CECClient);
            this.m_CECClient.createPartition(pILPARDataBean, pILPARProfileDataBean);
            this.m_partName = null;
        }
    }

    private void doProfileCreate() throws PIHscClientException {
        String string = null;
        String string2 = null;
        PIHSCLPARClient pIHSCLPARClient = null;
        for (int i = 0; i < this.m_input.size(); ++i) {
            int n;
            Object object;
            PILPARProfileDataBean pILPARProfileDataBean = new PILPARProfileDataBean();
            Boolean[] booleanArray = new Boolean[6];
            pILPARProfileDataBean.setTaggedIOInfo(booleanArray);
            CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(i), true, this.m_delimiter);
            Iterator iterator = cSVRecord.iterator();
            Vector<String> vector = new Vector<String>();
            boolean bl = false;
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                n = ((String)object).indexOf("=");
                if (n == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string3 = ((String)object).substring(0, n);
                String string4 = ((String)object).substring(n + 1);
                if (string3.length() == 0 || string4.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                if ("name".equals(string3)) {
                    pILPARProfileDataBean.setName(string4);
                    this.m_partProfName = string4;
                    continue;
                }
                if (PARTITION_NAME_ATTR.equals(string3)) {
                    this.m_partName = string4;
                    continue;
                }
                if ("lpar_id".equals(string3)) {
                    string = string4 + "*" + this.m_intSysName;
                    continue;
                }
                if ("all_resources".equals(string3) && string4.equals("1")) {
                    bl = true;
                    PIProfCommandUtils.setProfBean(pILPARProfileDataBean, string3, string4, this.m_intSysName, 0);
                    continue;
                }
                if (!(!bl || string3.equals("auto_start") || string3.equals("boot_mode") || string3.equals("load_source_slot") || string3.equals("alt_restart_device_slot") || string3.equals("console_slot") || string3.equals("alt_console_slot") || string3.equals("op_console_slot") || string3.equals("conn_monitoring"))) {
                    String string5 = "auto_start, boot_mode, load_source_slot, alt_restart_device_slot, console_slot, alt_console_slot, op_console_slot, " + HSCResourceBundleUtil.getMessage("HSCCommonBundle", "OR") + " " + "conn_monitoring";
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", new String[]{string5}, null);
                }
                PIProfCommandUtils.setProfBean(pILPARProfileDataBean, string3, string4, this.m_intSysName, 0);
                vector.add(string3);
            }
            if (string == null && this.m_partName == null) {
                String[] stringArray = new String[]{"lpar_name | lpar_id"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", stringArray, null);
            }
            if (string != null && this.m_partName != null) {
                String[] stringArray = new String[]{"lpar_name, lpar_id"};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", stringArray, null);
            }
            pIHSCLPARClient = string != null ? this.m_factory.createLPARClient(this.m_managedSystem, string, true) : this.m_factory.createLPARClient(this.m_managedSystem, this.m_partName, false);
            if (pIHSCLPARClient == null) {
                if (this.m_partName != null) {
                    String[] stringArray = new String[]{this.m_partName};
                    throw new PIHscClientException("8000", "HSCExceptionBundle", "8012", stringArray, null);
                }
                String[] stringArray = new String[]{string.substring(0, string.indexOf(42))};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "8011", stringArray, null);
            }
            object = pIHSCLPARClient.getLPARDataBean(new String[]{"resource_config"});
            n = ((PILPARDataBean)object).getDefinitionState().intValue();
            pILPARProfileDataBean.setOsType(PILPARProfileDataBean.mapDefinitionStateToOsType(n));
            pILPARProfileDataBean.setLparId(((PILPARDataBean)object).m_internalName);
            if (pILPARProfileDataBean.isOS400Prof()) {
                if (bl) {
                    for (int j = 0; j < vector.size(); ++j) {
                        string2 = (String)vector.get(j);
                        if (string2.equals("load_source_slot") || string2.equals("alt_restart_device_slot") || string2.equals("console_slot") || string2.equals("alt_console_slot") || string2.equals("op_console_slot") || string2.equals("conn_monitoring")) continue;
                        throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string2}, null);
                    }
                }
            } else if (bl) {
                for (int j = 0; j < vector.size(); ++j) {
                    string2 = (String)vector.get(j);
                    if (string2.equals("auto_start") || string2.equals("boot_mode") || string2.equals("conn_monitoring")) continue;
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", new String[]{string2}, null);
                }
            }
            PIProfCommandUtils.advValidateProfile(pILPARProfileDataBean, this.m_CECClient);
            pIHSCLPARClient.createProfile(pILPARProfileDataBean);
            this.m_partProfName = null;
            string = null;
            this.m_partName = null;
        }
    }

    private void setSysProfData(PISysProfDataBean pISysProfDataBean, String string, String string2) throws PIHscClientException {
        if ("name".equals(string)) {
            pISysProfDataBean.setName(string2);
            this.m_sysProfName = string2;
        } else if ("lpar_ids".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartIDs(stringArray);
        } else if ("lpar_names".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setPartNames(stringArray);
        } else if ("profile_names".equals(string)) {
            String[] stringArray = PIHMCCommandUtils.parseList(string2, this.m_delimiter);
            pISysProfDataBean.setProfNames(stringArray);
        } else {
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE", stringArray, null);
        }
    }

    private void validateSysProfData(PISysProfDataBean pISysProfDataBean) throws PIHscClientException {
        String string = pISysProfDataBean.getName();
        String[] stringArray = pISysProfDataBean.getPartIDs();
        String[] stringArray2 = pISysProfDataBean.getPartNames();
        String[] stringArray3 = pISysProfDataBean.getProfNames();
        String string2 = "";
        if (string == null) {
            string2 = "name";
        }
        if (stringArray == null && stringArray2 == null) {
            string2 = string2 + ", lpar_ids | lpar_names";
        }
        if (stringArray3 == null) {
            string2 = string2 + ", profile_names";
        }
        if (string2.length() > 0) {
            if (string2.startsWith(", ")) {
                string2 = string2.substring(2, string2.length());
            }
            String[] stringArray4 = new String[]{string2};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_ATTRIBUTE_ERROR", stringArray4, null);
        }
        try {
            if (!PIHscUtil.isCorrectNameLength(string, 31)) {
                String[] stringArray5 = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_PROF_NAME_LENGTH", stringArray5, null);
            }
            if (!PIHscUtil.nameHasCorrectCharacters(string)) {
                String[] stringArray6 = new String[]{"name=" + string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray6, null);
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray7 = new String[]{"name=" + string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_ATTRIBUTE_VALUE", stringArray7, null);
        }
        if (stringArray != null && stringArray2 != null) {
            String[] stringArray8 = new String[]{"lpar_ids and lpar_names"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_ATTRIBUTES", stringArray8, null);
        }
        if (stringArray != null && stringArray3.length != stringArray.length || stringArray2 != null && stringArray3.length != stringArray2.length) {
            String[] stringArray9 = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_SYSPROF_LIST_LENGTHS", stringArray9, null);
        }
        String[] stringArray10 = stringArray2 != null ? stringArray2 : stringArray;
        for (int i = 0; i < stringArray10.length; ++i) {
            for (int j = i + 1; j < stringArray10.length; ++j) {
                if (!stringArray10[i].equals(stringArray10[j])) continue;
                String[] stringArray11 = new String[]{string};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DUPLICATE_PARTITIONS", stringArray11, null);
            }
        }
    }

    private void doSysProfCreate() throws PIHscClientException {
        for (int i = 0; i < this.m_input.size(); ++i) {
            PISysProfDataBean pISysProfDataBean = new PISysProfDataBean();
            CSVRecord cSVRecord = new CSVRecord((String)this.m_input.get(i), true, this.m_delimiter);
            Iterator iterator = cSVRecord.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                int n = string.indexOf("=");
                if (n == -1) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                String string2 = string.substring(0, n);
                String string3 = string.substring(n + 1);
                if (string2.length() == 0 || string3.length() == 0) {
                    throw new PIHscClientException("8000", "PIHscCmdLineBundle", "INVALID_CFG_DATA", null, null);
                }
                this.setSysProfData(pISysProfDataBean, string2, string3);
            }
            this.validateSysProfData(pISysProfDataBean);
            this.m_CECClient.createSysProf(pISysProfDataBean);
            this.m_sysProfName = null;
        }
    }

    private void performCommand() throws PIHscClientException {
        String string = null;
        this.checkParameters();
        PICECDataBean pICECDataBean = this.m_CECClient.getCECDataBean(new String[]{"state"});
        int n = pICECDataBean.getCecState().intValue();
        if ("lpar".equals(this.m_resourceType) || "prof".equals(this.m_resourceType)) {
            if (n != 17 && n != 1) {
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "9010", null, null);
            }
        } else {
            if (n == 254 || n == 241 || n == 242 || n == 250) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0237", stringArray, null);
            }
            if (n == 251 || n == 253) {
                String[] stringArray = new String[]{pICECDataBean.getCECStateString()};
                throw new PIHscClientException("8000", "HSCCIMExceptionBundle", "0239", stringArray, null);
            }
        }
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_factory = PIHSCClientObjectFactory.getInstance(string, null);
        if ("lpar".equals(this.m_resourceType)) {
            this.doPartitionCreate();
        } else if ("prof".equals(this.m_resourceType)) {
            this.doProfileCreate();
        } else {
            this.doSysProfCreate();
        }
        if (this.m_writeStatus) {
            this.m_writeStatus = false;
            this.m_out.print('\u0000');
        }
    }

    private void checkParameters() throws PIHscClientException {
        String string = "";
        if (this.m_resourceType == null || !"lpar".equals(this.m_resourceType) && !"prof".equals(this.m_resourceType) && !"sysprof".equals(this.m_resourceType)) {
            string = "-r";
        }
        if (this.m_managedSystem == null || this.m_managedSystem.length() == 0) {
            string = string + ", -m";
        }
        if (!(this.m_filename != null && this.m_filename.length() != 0 || this.m_inputData != null && this.m_inputData.length() != 0)) {
            string = string + ", -f | -i";
        }
        if (string.length() > 0) {
            if (string.startsWith(", ")) {
                string = string.substring(2, string.length());
            }
            String[] stringArray = new String[]{string};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "REQUIRED_PARMS_ERROR", stringArray, null);
        }
        if (this.m_input == null || this.m_input.size() == 0) {
            String[] stringArray = new String[]{this.m_filename};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_NOT_FOUND", stringArray, null);
        }
    }

    private void mapParameters(HashMap hashMap) throws PIHscClientException {
        this.m_managedSystem = (String)hashMap.get("-m");
        this.m_resourceType = (String)hashMap.get("-r");
        this.m_filename = (String)hashMap.get("-f");
        this.m_inputData = (String)hashMap.get("-i");
        if (this.m_inputData != null && this.m_filename != null) {
            String[] stringArray = new String[]{"[-f | -i]"};
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "MUTUALLY_EXCLUSIVE_PARMS", stringArray, null);
        }
        this.m_input = new Vector();
        if (this.m_inputData != null) {
            this.m_input.add(this.m_inputData);
        } else if (this.m_filename != null) {
            try {
                this.m_input = PIHMCCommandUtils.readInputFile(this.m_filename);
            }
            catch (FileNotFoundException fileNotFoundException) {
                String[] stringArray = new String[]{this.m_filename};
                throw new PIHscClientException("8000", "PIHscCmdLineBundle", "FILE_NOT_FOUND", stringArray, null);
            }
            catch (IOException iOException) {
                String[] stringArray = new String[]{this.m_filename};
                throw new PIHscClientException("8000", "HSCExceptionBundle", "800E", stringArray, null);
            }
        }
        this.handleDeprecatedSyntax(hashMap);
    }

    private void handleDeprecatedSyntax(HashMap hashMap) throws PIHscClientException {
        String string = (String)hashMap.get("-p");
        if (string != null) {
            throw new PIHscClientException("8000", "PIHscCmdLineBundle", "DEPRECATED_MKSYSCFG_P_PARM", null, null);
        }
    }

    public static void printHelp(PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print('\u0000');
        }
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "MKSYSCFG_HELP"));
        printStream.println(HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "MKSYSCFG_ATTR_HELP_2"));
    }

    public static int callCommandFromRouter(PIHSCCECClient pIHSCCECClient, String[] stringArray, PrintStream printStream, boolean bl) {
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        PISystemConfigurationCreate pISystemConfigurationCreate = new PISystemConfigurationCreate(pIHSCCECClient, printStream, bl);
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            HashMap hashMap = PIHMCCommandUtils.parseParameters(arrayList, pISystemConfigurationCreate.m_validParms);
            pISystemConfigurationCreate.mapParameters(hashMap);
            pISystemConfigurationCreate.performCommand();
        }
        catch (PIHscClientException pIHscClientException) {
            if (bl) {
                printStream.print('\u0001');
            }
            pIHscClientException.printStackTrace(System.out);
            if ("8000".equals(pIHscClientException.getHscExId())) {
                printStream.println(pIHscClientException.getMessage());
            } else {
                String string;
                if ("lpar".equals(pISystemConfigurationCreate.m_resourceType)) {
                    Object[] objectArray = new String[]{pISystemConfigurationCreate.m_partName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CREATE_PARTITION_NAME_ERROR", "", objectArray);
                } else if ("prof".equals(pISystemConfigurationCreate.m_resourceType)) {
                    Object[] objectArray = new String[]{pISystemConfigurationCreate.m_partProfName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CREATE_PROF_ERROR", "", objectArray);
                } else {
                    Object[] objectArray = new String[]{pISystemConfigurationCreate.m_sysProfName};
                    string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CREATE_SYS_PROF_ERROR", "", objectArray);
                }
                printStream.println(string);
                string = pIHscClientException.getMessage();
                if (string == null || string.length() == 0) {
                    string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
                }
                printStream.println(string);
            }
            n = 1;
        }
        catch (Exception exception) {
            if (bl) {
                printStream.print('\u0001');
            }
            exception.printStackTrace(System.out);
            String string = "";
            if ("lpar".equals(pISystemConfigurationCreate.m_resourceType)) {
                Object[] objectArray = new String[]{pISystemConfigurationCreate.m_partName};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CREATE_PARTITION_NAME_ERROR", "", objectArray);
            } else if ("prof".equals(pISystemConfigurationCreate.m_resourceType)) {
                Object[] objectArray = new String[]{pISystemConfigurationCreate.m_partProfName};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CREATE_PROF_ERROR", "", objectArray);
            } else {
                Object[] objectArray = new String[]{pISystemConfigurationCreate.m_sysProfName};
                string = HSCResourceBundleUtil.getMessage("PIHscCmdLineBundle", "CREATE_SYS_PROF_ERROR", "", objectArray);
            }
            printStream.println(string);
            string = HSCResourceBundleUtil.getMessage("HSCExceptionBundle", "8016");
            printStream.println(string);
            n = 1;
        }
        return n;
    }

    public static long decodeStrValue(String string) {
        if (string == null) {
            return 0L;
        }
        return Long.decode(string);
    }
}

